* gof_peas.sas;
options pageno=1 linesize=80;
title 'Goodness-of-fit test for Mendel data';
data peas;
	input phenotype :$12. obsfreq;
	datalines;
round_yellow  315
round_green   101
wrink_yellow  108
wrink_green    32
;
run;
* Print data set;
proc print data=peas;
run;
* Goodness-of-fit test (Chi-square only);
proc freq data=peas order=data;
	tables phenotype / testp=(0.5625 0.1875 0.1875 0.0625) chisq cellchi2 expected;
	weight obsfreq;
	* Compute exact test if frequencies low, takes too long for large data sets;
	exact chisq;
run;
quit;
